/* OLTP read query workload */

/*
----------
*/

/*
-- oltp_read_select_01 (randfourram)
-- single random row select on an index int field
-- uses: fourram
-- might use index on: fourram.p_key
-- returns 1 row
*/

select p_key, p_code, p_date, p_signed, p_name
	from fourram
	where p_key = 100;

/*
----------
*/

/*
-- oltp_read_select_02 (randbase)
-- single table random contiguous range select on an indexed int field, sort on an indexed character field
-- uses: hundred
-- might use index on: hundred.h_key, hundred.h_name (probably won't bother with the index with only 200 rows to sort)
-- returns 201 rows
*/

select h_key, h_code, h_date, h_signed, h_name
	from hundred
	where h_key between 100 and 100+200
	order by h_name;

/*
----------
*/

/*
-- oltp_read_select_03
-- single fixed row select on an indexed int field
-- uses: tenpct
-- might use index on: tenpct.t_key
-- returns 1 row
*/

select t_key, t_int, t_signed, t_double, t_code, t_name
	from tenpct
	where t_key = 1001;

/*
----------
*/

/*
-- oltp_read_select_04
-- single fixed row select on an indexed text field
-- uses: updates
-- might use index on: updates.p_code
-- returns 1 row
*/

select p_key, p_int, p_signed, p_double, p_code, p_name
	from updates
	where p_code = 'BENCHMARKS';

/*
----------
*/

/*
-- oltp_read_select_05
-- single table contiguous range select on an indexed int field
-- uses: updates
-- might use index on: updates.p_key
-- returns 100 rows
*/

select p_key, p_int, p_signed, p_double, p_code, p_name
	from updates
	where p_key <= 100;

/*
----------
*/

/*
-- oltp_read_select_06 (randbase)
-- single random row select on an indexed int field
-- uses: updates
-- might use index on: updates.p_int
-- returns 1 row
*/

select p_key, p_int, p_signed, p_double, p_code, p_name
	from updates
	where p_int = 100;

/*
----------
*/

/*
-- oltp_read_select_07
-- single table contiguous range select on an indexed int field
-- uses: uniques
-- might use index on: uniques.u_key
-- returns 1 row
*/

select u_key, u_int, u_signed, u_double, u_code, u_name
	from uniques
	where u_key <= 1000;

/*
----------
*/

/*
-- oltp_read_select_08 (randbillion)
-- single table multiple index range select on an indexed character field and indexed int field
-- uses: tenpct
-- might use index on: tenpct.t_name, tenpct.t_key
-- returns ~1 rows (depends on random input)
*/

select t_key, t_int, t_signed, t_double, t_code, t_name
	from tenpct
	where t_name = 'THE+ASAP+BENCHMARKS+' 
		and (t_key between 100 and 100+10000);

/*
----------
*/

/*
-- oltp_read_select_09
-- single single row select from a single table on an indexed float field
-- uses: tenpct
-- might use index on: tenpct.t_signed
-- returns 1 row (the minimum t_signed value in the table)
*/

select t_key, t_int, t_signed, t_double, t_code, t_name
	from tenpct
	where t_signed <= -500000000;

/*
----------
*/

/*
-- oltp_read_select_10
-- single table contiguous range select on an indexed float field, order by an indexed int field
-- uses: tenthou
-- might use index on: tenthou.t_signed, tenthou.t_key
-- returns 2.5% of the rows (250 rows)
*/

select t_key, t_int, t_signed, t_double, t_code, t_name
	from tenthou
	where t_signed <= -475000000
	order by t_key;

/*
----------
*/

/*
-- oltp_read_select_11
-- index scan (row doesn't exist in index)
-- uses: twomill
-- might use index on: twomill.p_key
-- returns 0 rows
*/

select p_key, p_int, p_signed, p_double, p_code, p_name
	from twomill
	where p_key = 1;

/*
----------
*/

/*
-- oltp_read_select_12
-- single table multiple index range select on an indexed character field and indexed float field
-- uses: tenpct
-- might use index on: tenpct.t_name, tenpct.t_signed
-- returns 0.01% of rows (108 rows)
*/

select t_key, t_int, t_signed, t_double, t_code, t_name
	from tenpct
	where t_name like 'THE+%'
		and t_signed > 499000000
	order by t_key;

/*
----------
*/

/*
-- oltp_read_select_13
-- single table range select and ordering on an indexed date field
-- uses: tenpct
-- might use index on: tenpct.t_date
-- returns ~0.05% of rows (~500 rows, or actually 439 rows)
*/

select t_key, t_int, t_signed, t_double, t_code, t_name
	from tenpct
	where t_date > '12/15/1999'
	order by t_date;

/*
----------
*/

/*
-- oltp_read_select_14
-- single table range select on an indexed date field
-- uses: tenpct
-- might use index on: tenpct.t_date
-- returns 328 rows
*/

select t_key, t_int, t_signed, t_double, t_code, t_name
	from tenpct
	where t_date between '01/10/1942' and '01/21/1942'
	order by t_key;

/*
----------
*/

/*
-- oltp_read_select_15
-- tablescan on an unindexed character field (row doesn't exist) -- will cause full tablescan
-- uses: uniques
-- no index used
-- returns 0 rows
*/

select u_key, u_int, u_signed, u_double, u_code, u_name
	from uniques
	where u_name = 'xxxxxxxxxx';

/*
----------
*/

/*
-- oltp_read_select_16
-- multiple row select from a single table on an indexed int field, sort on unindexed character and indexed float fields
-- uses: hunthou
-- might use index on: hunthou.h_address (this field deliberately not indexed), hunthou.h_signed
-- returns 100 rows
*/

select distinct h_signed, h_address
	from hunthou
	where hunthou.h_signed = 100
	order by h_address;

/*
----------
*/

/*
-- oltp_read_select_17
-- multiple row select and sort from a single table on an indexed fixed precision numeric field
-- uses: tenthou
-- might use index on: tenthou.t_decim
-- returns 10% of rows (1000 rows)
*/

select distinct t_decim
	from tenthou
	order by t_decim;

/*
----------
*/

/*
-- oltp_read_select_18
-- single table range select on an indexed int field, sort on an indexed character field
-- uses: tenthou
-- might use index on: tenthou.t_signed, tenthou.t_name
-- returns 1% of rows (100 rows)
*/

select t_key, t_int, t_signed, t_double, t_code, t_name
	from tenthou
	where t_signed <= -490000000
	order by t_name, t_key;

/*
----------
----------
*/

/*
-- oltp_read_join_01 (randbase)
-- single random row select on an indexed int field, two table equality join on unique indexed int fields
-- uses: updates, hundred
-- might use index on: updates.p_key, hundred.h_key
-- returns 1 row
*/

select updates.p_key, updates.p_code, hundred.h_date, hundred.h_signed, hundred.h_name, hundred.h_address
	from updates, hundred
	where updates.p_key = 100
		and updates.p_key = hundred.h_key;

/*
----------
*/

/*
-- oltp_read_join_02 (randtwomill)
-- single random row select on an indexed int field, two table equality join on indexed character fields
-- uses: twomill, uniques
-- might use index on: twomill.p_key, twomill.p_code, uniques.u_code
-- returns ~0 rows
*/

select twomill.p_key, twomill.p_code, uniques.u_date, uniques.u_signed, uniques.u_name
	from twomill, uniques
	where twomill.p_key = 100
		and twomill.p_code = uniques.u_code;

/*
----------
*/

/*
-- oltp_read_join_03 (randfivemill1, randfivemill2, randfivemill3, randfivemill4, randfivemill5)
-- single table random in (group) select, two table equality join on indexed int fields, order by on an indexed character field
-- uses: fivemill, updates
-- might use index on: fivemill.h_key, fivemill.h_code, updates.p_key
-- returns between 0-5 rows
*/

select fivemill.h_key, fivemill.h_code, updates.p_date, updates.p_signed, updates.p_name
	from fivemill, updates
	where fivemill.h_key in (100,200,300,400,500) 
	and fivemill.h_key = updates.p_key
	order by fivemill.h_code;

/*
----------
*/

/*
-- oltp_read_join_04 (randbase)
-- contiguous range select on an indexed int field, two table equality join on indexed int fields, dual sort on indexed character field, indexed date field
-- uses: updates, hundred
-- might use index on: updates.p_key, updates.p_code, hundred.h_key, hundred.h_date
-- returns 21 rows
*/

select updates.p_key, updates.p_code, 
		hundred.h_date, hundred.h_signed, hundred.h_name, hundred.h_address
	from updates, hundred
	where (hundred.h_key between 100 and 100+20) 
		and updates.p_key = hundred.h_key
	order by updates.p_code, hundred.h_date;

/*
----------
*/

/*
-- oltp_read_join_05
-- multiple table range select on indexed int fields, two table inequality join on indexed int fields
-- uses: uniques, tenpct
-- might use index on: uniques.u_key, tenpct.t_key
-- returns 11 rows
*/

select uniques.u_key, uniques.u_name, tenpct.t_key, tenpct.t_signed
	from uniques, tenpct
	where uniques.u_key >= 1000000000
		and tenpct.t_int <= uniques.u_int
		and tenpct.t_key >= 999990000;

/*
----------
*/

/*
-- oltp_read_join_06
-- multiple row select from a single table on an indexed character field; two table equality join on indexed int fields; sort on indexed float field (uniques.u_signed), unindexed character field (uniques.u_name), unindexed int field (fourram.p_signed), unindexed character field (fourram.p_name)
-- uses: uniques, fourram
-- might use index on: uniques.u_key, uniques.u_code, fourram.p_key
-- returns 2 rows
*/

select distinct uniques.u_signed, uniques.u_name, fourram.p_signed, fourram.p_name
	from uniques, fourram
	where uniques.u_key = fourram.p_key
		and uniques.u_code like 'AA%';

/*
----------
*/

/*
-- oltp_read_join_07
-- single row select on an indexed int field, two table equality join on indexed int fields
-- uses: uniques, hundred
-- might use index on: uniques.u_key (x2), hundred.h_key
-- returns 1 row
*/

select uniques.u_signed, uniques.u_name, hundred.h_signed, hundred.h_name
	from uniques, hundred
	where uniques.u_key = hundred.h_key
		and uniques.u_key = 1001;

/*
----------
*/

/*
-- oltp_read_join_08
-- single row select on an indexed character field, two table equality join on indexed character fields
-- uses: uniques, hundred
-- might use index on: uniques.u_code (x2), hundred.h_code
-- returns 1 row
*/

select uniques.u_signed, uniques.u_name, hundred.h_signed, hundred.h_name
	from uniques, hundred
	where uniques.u_code = hundred.h_code
		and uniques.u_code = 'BENCHMARKS';

/*
----------
*/

/*
-- oltp_read_join_09
-- single row select on an indexed integer field, three table equality join on indexed integer fields
-- uses: uniques, hundred, tenpct
-- might use index on: uniques.u_key (x2), hundred.h_key, tenpct.t_key
-- returns 1 row
*/

select uniques.u_signed, uniques.u_date, hundred.h_signed, hundred.h_date, tenpct.t_signed, tenpct.t_date
	from uniques, hundred, tenpct
	where uniques.u_key = hundred.h_key
		and uniques.u_key = tenpct.t_key
		and uniques.u_key = 1001;

/*
----------
*/

/*
-- oltp_read_join_10
-- single row select on an indexed character field, three table equality join on indexed character fields
-- uses: uniques, hundred, tenpct
-- might use index on: uniques.u_code (x2), hundred.h_code, tenpct.t_code
-- returns 1 row
*/

select uniques.u_signed, uniques.u_date, hundred.h_signed, hundred.h_date, tenpct.t_signed, tenpct.t_date
	from uniques, hundred, tenpct
	where uniques.u_code = hundred.h_code
		and uniques.u_code = tenpct.t_code
		and uniques.u_code = 'BENCHMARKS';

/*
----------
*/

/*
-- oltp_read_join_11
-- single row select on an indexed int field, four table equality join on indexed int fields
-- uses: uniques, hundred, tenpct, updates
-- might use index on: uniques.u_key (x2), hundred.h_key, tenpct.t_key, updates.p_key
-- returns 1 row
*/

select uniques.u_date, hundred.h_date, tenpct.t_date, updates.p_date
	from uniques, hundred, tenpct, updates
	where uniques.u_key = hundred.h_key
		and uniques.u_key = tenpct.t_key
		and uniques.u_key = updates.p_key
		and uniques.u_key = 1001;

/*
----------
*/

/*
-- oltp_read_join_12
-- single row select on an indexed character field, four table equality join on indexed character fields
-- uses: uniques, hundred, tenpct, updates
-- might use index on: uniques.u_code (x2), hundred.h_code, tenpct.t_code, updates.p_code
-- returns 1 row
*/

select uniques.u_date, hundred.h_date, tenpct.t_date, updates.p_date
	from uniques, hundred, tenpct, updates
	where uniques.u_code = hundred.h_code
		and uniques.u_code = tenpct.t_code
		and uniques.u_code = updates.p_code
		and uniques.u_code = 'BENCHMARKS';

/*
----------
*/

/*
-- oltp_read_join_13
-- multiple contiguous range select from a single table on an indexed integer field, subselect on indexed float field using two table equality join on indexed integer fields
-- uses: uniques, tenpct
-- might use index on: uniques.u_key (x2), tenpct.t_signed, tenpct.t_key
-- returns 1027 rows
*/

select uniques.u_int, uniques.u_name
	from uniques
	where uniques.u_key <= 2000000
		and uniques.u_signed >
			(select avg(tenpct.t_signed)
			from tenpct
			where uniques.u_key = tenpct.t_key)
	order by u_int;

/*
----------
*/

/*
-- oltp_read_join_14
-- multiple contiguous range select from a single table on an indexed integer field, two table left outer equality join on indexed integer fields
-- uses: tenthou, tenpct
-- might use index on: tenthou.t_code, tenthou.t_key, tenpct.t_code
-- returns 10 rows
*/

select tenthou.t_key, tenthou.t_name, tenthou.t_signed, tenthou.t_code, tenpct.t_key
	from tenthou, tenpct
	where tenthou.t_code = tenpct.t_code(+) 
		and tenthou.t_key <= 1000000;

exit;
